#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>


static int debug = 0;

static const char libsysconfcpus_debug_envvar[] = "LIBSYSCONFCPUS_DEBUG";

static int do_debug() {
	return (debug || getenv(libsysconfcpus_debug_envvar));
}

static void dprintf(char *fmt, ...) {
	va_list ap;
	if (do_debug()) {
		va_start(ap, fmt);
		vfprintf(stderr, fmt, ap);
		va_end(ap);
		fflush(stderr);
	}
}





static void _libsysconfcpus_init(void) __attribute__ ((constructor));
static void _libsysconfcpus_fini(void) __attribute__ ((destructor));

static void _libsysconfcpus_init(void) {
	dprintf("libsysconfcpus: starting up\n");
}

static void _libsysconfcpus_fini(void) {
	dprintf("libsysconfcpus: shutting down\n");
}



