
// SimParm: Simple and flexible C++ configuration framework
// Copyright (C) 2007 Australian National University
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// Contact:
// Kevin Pulo
// kevin.pulo@anu.edu.au
// Leonard Huxley Bldg 56
// Australian National University, ACT, 0200, Australia

//package simparm.twiddler;

import java.io.*;
import java.util.*;


class ConfigEntryChoice extends ConfigEntryChooser {

	public int value;
	public Vector<String> value_name;
	public Vector<String> value_desc;

	public ConfigEntryChoice() {
		super();
		value = 0;
		value_name = new Vector<String>();
		value_desc = new Vector<String>();
	}

	public void doSpecificPrint(PrintStream out) {
		out.print(value);
	}

	public void readDefinitionSpecific(BufferedReader input) throws IOException {
		value = (int)readLong(input, "value");
		int numChoices = (int)readLong(input, "num_values");
		for (int i = 0; i < numChoices; i++) {
			String word[] = readLineWords(input, 2);
			if (word.length != 2) {
				System.err.println("Expected name-desc pair, found only one word");
				System.exit(1);
			}
			String _name = word[0];
			String _desc = word[1];
			value_name.add(_name);
			value_desc.add(_desc);
			chooser.add(_desc);
		}
		setValue(value, false, true);
	}

	public void setValue(int newvalue, boolean doprint, boolean updatefield) {
		if (newvalue != value) {
			value = newvalue;
			if (doprint) {
				doPrint();
			}
		}
		if (updatefield) {
			chooser.select(value);
		}
	}

	public boolean setValueFromInputStream(String word) {
		int index = value_name.indexOf(word);
		if (index >= 0) {
			setValue(index, false, true);
			return true;
		} else {
			try {
				index = Integer.parseInt(word);
				setValue(index, false, true);
				return true;
			} catch (NumberFormatException ex) {
				return false;
			}
		}
	}

}

