#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>

#define __USE_GNU
#include <dlfcn.h>
#undef __USE_GNU

//#include <unistd.h>

#include <X11/Xlib.h>
//#include <X11/Xutil.h>
//#include <X11/Xos.h>
//#include <X11/Xatom.h>
//#include <X11/extensions/shape.h>



static int debug = 0;

static const char libxmultiwin_debug_envvar[] = "LIBXMULTIWIN_DEBUG";

static int do_debug() {
	return (debug || getenv(libxmultiwin_debug_envvar));
}

static void dprintf(char *fmt, ...) {
	va_list ap;
	if (do_debug()) {
		va_start(ap, fmt);
		vfprintf(stderr, fmt, ap);
		va_end(ap);
		fflush(stderr);
	}
}





static void _libxmultiwin_init() __attribute__((constructor));
static void _libxmultiwin_fini() __attribute__((destructor));
static void _libxmultiwin_init(void);
static void _libxmultiwin_fini(void);

static void _libxmultiwin_init(void) {
	dprintf("libxmultiwin: starting up\n");
}

static void _libxmultiwin_fini(void) {
	dprintf("libxmultiwin: shutting down\n");
}



static void *libX11_handle = NULL;



static unsigned long num_windows = 0;
static unsigned long max_windows = 16;
static Window* windows = NULL;
static Window* shadows = NULL;


void init_windows() {
	if (windows == NULL) {
		windows = (Window*) malloc(max_windows * sizeof(Window*));
		shadows = (Window*) malloc(max_windows * sizeof(Window*));
	}
}

void add_shadow(Window window, Window shadow) {
	init_windows();

	dprintf("libxmultiwin: add_shadow: currently num_windows = %d and max_windows = %d\n", num_windows, max_windows);
	dprintf("libxmultiwin: add_shadow: adding window = 0x%x with shadow = 0x%x\n", window, shadow);
	if (num_windows + 1 >= max_windows) {
		// grow
		max_windows *= 2;
		windows = (Window*) realloc(windows, max_windows * sizeof(Window*));
		shadows = (Window*) realloc(shadows, max_windows * sizeof(Window*));
	}

	windows[num_windows] = window;
	shadows[num_windows] = shadow;
	num_windows++;
	dprintf("libxmultiwin: add_shadow: currently num_windows = %d and max_windows = %d\n", num_windows, max_windows);
}

static Window find_it(Window target, Window *targets, Window *others, unsigned long n) {
	unsigned long i = 0;

	init_windows();

	for (i = 0; i < n; i++) {
		//dprintf("libxmultiwin: find_it: target = 0x%x, targets[%d] = 0x%x, others[%d] = 0x%x\n", target, i, targets[i], i, others[i]);
		if (targets[i] == target) {
			//dprintf("libxmultiwin: find_it: target = 0x%x == targets[%d] = 0x%x, returning others[%d] = 0x%x\n", target, i, targets[i], i, others[i]);
			return others[i];
		}
	}
	//dprintf("libxmultiwin: find_it: not found, returning None\n");
	return None;
}

Window find_shadow_for_window(Window window) {
	return find_it(window, windows, shadows, num_windows);
}

Window find_window_for_shadow(Window shadow) {
	return find_it(shadow, shadows, windows, num_windows);
}

Bool have_window(Window window) {
	return (find_window_for_shadow(window) != None);
}

Bool have_shadow(Window shadow) {
	return (find_shadow_for_window(shadow) != None);
}


void init_dl_stuff() {
	if (!libX11_handle) {
#if defined(RTLD_NEXT)
		libX11_handle = RTLD_NEXT;
#else
		libX11_handle = dlopen("libX11.so.6", RTLD_LAZY);
#endif
		dprintf("libxmultiwin: XCreateWindow: libX11_handle = 0x%x\n", libX11_handle);
		if (!libX11_handle) {
			fprintf(stderr, "libxmultiwin: Error: Unable to find libX11.so: %s\n", dlerror());
			exit(1);
		}
	}
}

void init_dl_function(void **fnptr, const char *name) {
	const char *err;

	init_dl_stuff();

	if (fnptr == NULL) {
		return;
	}

	if (!*fnptr) {
		dlerror();
		*fnptr = dlsym(libX11_handle, name);
		dprintf("libxmultiwin: %s: underlying = 0x%x\n", name, fnptr);
		err = dlerror();
		if (err) {
			dprintf("libxmultiwin: %s: err = \"%s\"\n", name, err);
		}
		if (!*fnptr || err) {
			fprintf (stderr, "libxmultiwin: Error: Unable to find the underlying %s(): %s\n", name, dlerror());
			exit(1);
		}
	}
}



#include "libxlibtrace-trace.h"
#undef __TRACE__
#define __TRACE__(a,b,c)
#include "libxlibtrace-functions.h"

#undef __TRACE_LOCAL_VARS__
#define __TRACE_LOCAL_VARS__(funcname) \
		__REALTYPE_INDIRECT__(__TRACE_SAFERETTYPE_##funcname##__) _retval; \

#undef __TRACE_PRE_RUN_UNDERLYING_STYLE__
#define __TRACE_PRE_RUN_UNDERLYING_STYLE__(retstyle, argstyle, funcname) \

#undef __TRACE_POST_RUN_UNDERLYING_STYLE__
#define __TRACE_POST_RUN_UNDERLYING_STYLE__(retstyle, argstyle, funcname) \







#undef __TRACE_ADDITIONAL_POST_RUN_UNDERLYING_XCreateWindow__
#define __TRACE_ADDITIONAL_POST_RUN_UNDERLYING_XCreateWindow__ \
	dprintf("libxmultiwin: XCreateWindow: created window = 0x%x\n", retval); \

__TRACE_BEGIN_STYLE__(TYPED, FIXED, XCreateWindow)

	//init_dl_function(&underlying, "XCreateWindow");
	//__TRACE_GET_UNDERLYING__(XCreateWindow)

	//retval = (*underlying)(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	//dprintf("libxmultiwin: XCreateWindow: created window = 0x%x\n", retval);
	__TRACE_RUN_UNDERLYING_STYLE__(TYPED, FIXED, XCreateWindow)

	Window shadow_parent = parent;
	if (have_shadow(parent)) {
		shadow_parent = find_shadow_for_window(parent);
		dprintf("libxmultiwin: XCreateWindow: found shadow parent 0x%x\n", shadow_parent);
	}

	_retval = (*underlying)(display, shadow_parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	//_retval = (*underlying)(display, shadow_parent, x + width, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	dprintf("libxmultiwin: XCreateWindow: created shadow window = 0x%x\n", _retval);

	add_shadow(retval, _retval);

__TRACE_END_STYLE__(TYPED, FIXED, XCreateWindow)



__TRACE_BEGIN_STYLE__(TYPED, FIXED, XMapWindow)

//int XMapWindow(Display *display, Window w) {
	//static int (*underlying)(Display *display, Window w);
	//int retval;
	//int shadow;

	dprintf("libxmultiwin: XMapWindow(display = 0x%x, w = 0x%x): entered\n",
			display, w);

	init_dl_function(&underlying, "XMapWindow");

	dprintf("libxmultiwin: XMapWindow: about to call real XMapWindow\n");
	retval = (*underlying)(display, w);
	dprintf("libxmultiwin: XMapWindow: back now\n");
	dprintf("libxmultiwin: XMapWindow: result = %d\n", retval);

	if (have_shadow(w)) {
		Window shadow_w = find_shadow_for_window(w);
		dprintf("libxmultiwin: XMapWindow: calling real XMapWindow AGAIN with shadow window 0x%x\n", shadow_w);
		_retval = (*underlying)(display, shadow_w);
		dprintf("libxmultiwin: XMapWindow: back now AGAIN\n");
		dprintf("libxmultiwin: XMapWindow: shadow retval = %d\n", _retval);

		if (retval != _retval) {
			// FIXME: wtf does XMapWindow return anyway?
			dprintf("libxmultiwin: XMapWindow: Warning: retval != shadow retval\n");
		}
	}

	dprintf("libxmultiwin: XMapWindow(display = 0x%x, w = 0x%x) = %d\n",
			display, w, retval);

	return retval;
}


int XMapSubwindows(Display *display, Window w) {
	static int (*underlying)(Display *display, Window w);
	int retval;
	int shadow;

	dprintf("libxmultiwin: XMapSubwindows(display = 0x%x, w = 0x%x): entered\n",
			display, w);

	init_dl_function(&underlying, "XMapSubwindows");

	dprintf("libxmultiwin: XMapSubwindows: about to call real XMapSubwindows\n");
	retval = (*underlying)(display, w);
	dprintf("libxmultiwin: XMapSubwindows: back now\n");
	dprintf("libxmultiwin: XMapSubwindows: result = %d\n", retval);

	if (have_shadow(w)) {
		Window shadow_w = find_shadow_for_window(w);
		dprintf("libxmultiwin: XMapSubwindows: calling real XMapSubwindows AGAIN with shadow window 0x%x\n", shadow_w);
		shadow = (*underlying)(display, shadow_w);
		dprintf("libxmultiwin: XMapSubwindows: back now AGAIN\n");
		dprintf("libxmultiwin: XMapSubwindows: shadow retval = %d\n", shadow);

		if (retval != shadow) {
			// FIXME: wtf does XMapSubwindows return anyway?
			dprintf("libxmultiwin: XMapSubwindows: Warning: retval != shadow retval\n");
		}
	}

	dprintf("libxmultiwin: XMapSubwindows(display = 0x%x, w = 0x%x) = %d\n",
			display, w, retval);

	return retval;
}


int XChangeProperty(Display *display, Window w, Atom property, Atom type, int format, int mode, _Xconst unsigned char *data, int nelements) {
	static int (*underlying)(Display *display, Window w, Atom property, Atom type, int format, int mode, _Xconst unsigned char *data, int nelements);
	int retval;
	int shadow;

	dprintf("libxmultiwin: XChangeProperty(display = 0x%x, w = 0x%x, ***FIXME***): entered\n",
			display, w);

	init_dl_function(&underlying, "XChangeProperty");

	dprintf("libxmultiwin: XChangeProperty: about to call real XChangeProperty\n");
	retval = (*underlying)(display, w, property, type, format, mode, data, nelements);
	dprintf("libxmultiwin: XChangeProperty: back now\n");
	dprintf("libxmultiwin: XChangeProperty: result = %d\n", retval);

	if (have_shadow(w)) {
		Window shadow_w = find_shadow_for_window(w);
		dprintf("libxmultiwin: XChangeProperty: calling real XChangeProperty AGAIN with shadow window 0x%x\n", shadow_w);
		shadow = (*underlying)(display, shadow_w, property, type, format, mode, data, nelements);
		dprintf("libxmultiwin: XChangeProperty: back now AGAIN\n");
		dprintf("libxmultiwin: XChangeProperty: shadow retval = %d\n", shadow);

		if (retval != shadow) {
			// FIXME: wtf does XChangeProperty return anyway?
			dprintf("libxmultiwin: XChangeProperty: Warning: retval != shadow retval\n");
		}
	}

	dprintf("libxmultiwin: XChangeProperty(display = 0x%x, w = 0x%x, ***FIXME***) = %d\n",
			display, w, retval);

	return retval;
}


int XFillRectangle(Display *display, Drawable d, GC gc, int x, int y, unsigned int width, unsigned int height) {
	static int (*underlying)(Display *display, Drawable d, GC gc, int x, int y, unsigned int width, unsigned int height);
	int retval;
	int shadow;

	dprintf("libxmultiwin: XFillRectangle(display = 0x%x, d = 0x%x, gc = 0x%x, x = %d, y = %d, width = %u, height = %u): entered\n",
			display, d, gc, x, y, width, height);

	init_dl_function(&underlying, "XFillRectangle");

	dprintf("libxmultiwin: XFillRectangle: about to call real XFillRectangle\n");
	retval = (*underlying)(display, d, gc, x, y, width, height);
	dprintf("libxmultiwin: XFillRectangle: back now\n");
	dprintf("libxmultiwin: XFillRectangle: result = %d\n", retval);

	if (have_shadow(d)) {
		Window shadow_w = find_shadow_for_window(d);
		dprintf("libxmultiwin: XFillRectangle: calling real XFillRectangle AGAIN with shadow window 0x%x\n", shadow_w);
		shadow = (*underlying)(display, shadow_w, gc, x, y, width, height);
		dprintf("libxmultiwin: XFillRectangle: back now AGAIN\n");
		dprintf("libxmultiwin: XFillRectangle: shadow retval = %d\n", shadow);

		if (retval != shadow) {
			// FIXME: wtf does XFillRectangle return anyway?
			dprintf("libxmultiwin: XFillRectangle: Warning: retval != shadow retval\n");
		}
	}

	dprintf("libxmultiwin: XFillRectangle(display = 0x%x, d = 0x%x, gc = 0x%x, x = %d, y = %d, width = %u, height = %u) = %d\n",
			display, d, gc, x, y, width, height, retval);

	return retval;
}


int XFillPolygon(Display *display, Drawable d, GC gc, XPoint *points, int npoints, int shape, int mode) {
	static int (*underlying)(Display *display, Drawable d, GC gc, XPoint *points, int npoints, int shape, int mode);
	int retval;
	int shadow;

	dprintf("libxmultiwin: XFillPolygon(display = 0x%x, d = 0x%x, gc = 0x%x, points = 0x%x, npoints = %d, shape = %d, mode = %d): entered\n",
			display, d, gc, points, npoints, shape, mode);

	init_dl_function(&underlying, "XFillPolygon");

	dprintf("libxmultiwin: XFillPolygon: about to call real XFillPolygon\n");
	retval = (*underlying)(display, d, gc, points, npoints, shape, mode);
	dprintf("libxmultiwin: XFillPolygon: back now\n");
	dprintf("libxmultiwin: XFillPolygon: result = %d\n", retval);

	if (have_shadow(d)) {
		Window shadow_w = find_shadow_for_window(d);
		dprintf("libxmultiwin: XFillPolygon: calling real XFillPolygon AGAIN with shadow window 0x%x\n", shadow_w);
		shadow = (*underlying)(display, shadow_w, gc, points, npoints, shape, mode);
		dprintf("libxmultiwin: XFillPolygon: back now AGAIN\n");
		dprintf("libxmultiwin: XFillPolygon: shadow retval = %d\n", shadow);

		if (retval != shadow) {
			// FIXME: wtf does XFillPolygon return anyway?
			dprintf("libxmultiwin: XFillPolygon: Warning: retval != shadow retval\n");
		}

		//XFlush(display);
		//sleep(1);
	}

	dprintf("libxmultiwin: XFillPolygon(display = 0x%x, d = 0x%x, gc = 0x%x, points = 0x%x, npoints = %d, shape = %d, mode = %d) = %d\n",
			display, d, gc, points, npoints, shape, mode, retval);

	return retval;
}


int XNextEvent(Display *display, XEvent *event_return) {
	static int (*underlying)(Display *display, XEvent *event_return);
	int retval;
	int shadow;

	dprintf("libxmultiwin: XNextEvent(display = 0x%x, event_return = 0x%x): entered\n",
			display, event_return);

	init_dl_function(&underlying, "XNextEvent");

	dprintf("libxmultiwin: XNextEvent: about to call real XNextEvent\n");
	retval = (*underlying)(display, event_return);
	dprintf("libxmultiwin: XNextEvent: back now\n");
	dprintf("libxmultiwin: XNextEvent: result = %d\n", retval);

	if (have_window(event_return->xany.window)) {
		Window window_w = find_window_for_shadow(event_return->xany.window);
		dprintf("libxmultiwin: XNextEvent: munging shadow window 0x%x event to be for the real window 0x%x\n", event_return->xany.window, window_w);
		event_return->xany.window = window_w;

		//dprintf("libxmultiwin: XNextEvent: calling real XNextEvent AGAIN with shadow window 0x%x\n", shadow_w);
		//shadow = (*underlying)(display, shadow_w);
		//dprintf("libxmultiwin: XNextEvent: back now AGAIN\n");
		//dprintf("libxmultiwin: XNextEvent: shadow retval = %d\n", shadow);

		//if (retval != shadow) {
		//	// FIXME: wtf does XNextEvent return anyway?
		//	dprintf("libxmultiwin: XNextEvent: Warning: retval != shadow retval\n");
		//}
	}

	dprintf("libxmultiwin: XNextEvent(display = 0x%x, event_return = 0x%x) = %d\n",
			display, event_return, retval);

	return retval;
}


Bool XFilterEvent(XEvent *event, Window w) {
	static Bool (*underlying)(XEvent *event, Window w);
	Bool retval;
	Bool shadow;

	dprintf("libxmultiwin: XFilterEvent(event = 0x%x, w = 0x%x): entered\n",
			event, w);

	init_dl_function(&underlying, "XFilterEvent");

	dprintf("libxmultiwin: XFilterEvent: about to call real XFilterEvent\n");
	retval = (*underlying)(event, w);
	dprintf("libxmultiwin: XFilterEvent: back now\n");
	dprintf("libxmultiwin: XFilterEvent: result = %d\n", retval);

	if (have_shadow(w)) {
		Window shadow_w = find_shadow_for_window(w);
		dprintf("libxmultiwin: XFilterEvent: calling real XFilterEvent AGAIN with shadow window 0x%x\n", shadow_w);
		shadow = (*underlying)(event, shadow_w);
		dprintf("libxmultiwin: XFilterEvent: back now AGAIN\n");
		dprintf("libxmultiwin: XFilterEvent: shadow retval = %d\n", shadow);

		if (retval != shadow) {
			dprintf("libxmultiwin: XFilterEvent: Warning: retval != shadow retval\n");
		}
	}

	/*
	if (have_window(event->xany.window)) {
		Window window_w = find_window_for_shadow(event->xany.window);
		dprintf("libxmultiwin: XFilterEvent: munging shadow window 0x%x event to be for the real window 0x%x\n", event->xany.window, window_w);
		event->xany.window = window_w;

		//dprintf("libxmultiwin: XFilterEvent: calling real XFilterEvent AGAIN with shadow window 0x%x\n", shadow_w);
		//shadow = (*underlying)(event, shadow_w);
		//dprintf("libxmultiwin: XFilterEvent: back now AGAIN\n");
		//dprintf("libxmultiwin: XFilterEvent: shadow retval = %d\n", shadow);

		//if (retval != shadow) {
		//	dprintf("libxmultiwin: XFilterEvent: Warning: retval != shadow retval\n");
		//}
	}
	*/

	dprintf("libxmultiwin: XFilterEvent(event = 0x%x, w = 0x%x) = %d\n",
			event, w, retval);

	return retval;
}


int XSelectInput(Display *display, Window w, long event_mask) {
	static int (*underlying)(Display *display, Window w, long event_mask);
	int retval;
	int shadow;

	dprintf("libxmultiwin: XSelectInput(display = 0x%x, w = 0x%x, event_mask = %d): entered\n",
			display, w, event_mask);

	init_dl_function(&underlying, "XSelectInput");

	dprintf("libxmultiwin: XSelectInput: about to call real XSelectInput\n");
	retval = (*underlying)(display, w, event_mask);
	dprintf("libxmultiwin: XSelectInput: back now\n");
	dprintf("libxmultiwin: XSelectInput: result = %d\n", retval);

	if (have_shadow(w)) {
		Window shadow_w = find_shadow_for_window(w);
		dprintf("libxmultiwin: XSelectInput: calling real XSelectInput AGAIN with shadow window 0x%x\n", shadow_w);
		shadow = (*underlying)(display, shadow_w, event_mask);
		dprintf("libxmultiwin: XSelectInput: back now AGAIN\n");
		dprintf("libxmultiwin: XSelectInput: shadow retval = %d\n", shadow);

		if (retval != shadow) {
			// FIXME: wtf does XSelectInput return anyway?
			dprintf("libxmultiwin: XSelectInput: Warning: retval != shadow retval\n");
		}
	}

	dprintf("libxmultiwin: XSelectInput(display = 0x%x, w = 0x%x, event_mask = %d) = %d\n",
			display, w, event_mask, retval);

	return retval;
}






